// testapp.c
//
//	$Id: testapp.c,v 1.2 2000/02/03 17:25:45 pbj Exp $
//

#define MEMLOCK_TEST	0
#define	ENTROPY_TEST	1
#define CACHE_TEST		0
#define INACTIVITY_TEST	0

#include <windows.h>
#include <stdio.h>
#include <conio.h>

#define PGP_WIN32 	1
#define WINNT		0
#define WIN95		1
#include "PGPsdkDriver.h"

//____________________________
//
//	main loop
 
int main (int argc, char *argv[]) {	

	PPGPENTROPYSTRUCT 	ppes			= NULL;
	INT					iBufferLen		= 0;
	BOOL				bLoop			= TRUE;

	HANDLE 				hPGPUtilDriver;
	PGPGENERICSTRUCT	pgs;
	PGPCACHESTRUCT		pcs;
	PGPINACTIVITYSTRUCT	pis;
	PGPMEMLOCKSTRUCT	pmls;
	DWORD				dwReturned;
	INT					j;
	CHAR				sz[80];
	PVOID				p[10];


#if WIN95
	hPGPUtilDriver = CreateFile ("\\\\.\\PGPsdk.vxd", 
#endif
#if WINNT
	hPGPUtilDriver = CreateFile ("\\\\.\\PGPsdkDriver", 
#endif
		GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 
		0, NULL);

	if (hPGPUtilDriver == INVALID_HANDLE_VALUE) 
	{
		printf ("\nDriver open failed : %i\n", GetLastError ());
		return 0;
	}

	iBufferLen = sizeof(pgs);
	pgs.ulOperation = kPGPUDOperation_QueryVersion;
	if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_GENERIC, 
		&pgs, iBufferLen, &pgs, iBufferLen, &dwReturned, NULL))
	{	
		printf ("\n\nError: %x, Version: %s\n", 
				pgs.ulError, pgs.ucBuffer);
	}

#if MEMLOCK_TEST
	iBufferLen = sizeof(pmls);
	for (j=0; j<10; j++)
	{
		p[j] = VirtualAlloc (NULL, 1024, MEM_COMMIT, PAGE_READWRITE);

		pmls.ulOperation = kPGPUDOperation_LockMemory;
		pmls.pMem = p[j];
		pmls.ulNumBytes = 1024;
		if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_MEMLOCK, 
			&pmls, iBufferLen, &pmls, iBufferLen, &dwReturned, NULL))
		{	
			printf ("\n\nError: %x\n", 
					pmls.ulError);
		}
		else 
		{
			printf ("\nerr = %li", GetLastError ());
		}
	}

	for (j=1; j<9; j++)
	{
		pmls.ulOperation = kPGPUDOperation_UnlockMemory;
		pmls.pMem = p[j];
		pmls.ulNumBytes = 1024;
		if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_MEMLOCK, 
			&pmls, iBufferLen, &pmls, iBufferLen, &dwReturned, NULL))
		{	
			printf ("\n\nError: %x\n", 
					pmls.ulError);
		}
		else 
		{
			printf ("\nerr = %li", GetLastError ());
		}

		VirtualFree(p[j], 0, MEM_RELEASE);
	}
#endif // MEMLOCK_TEST

#if ENTROPY_TEST
	iBufferLen = sizeof(PGPENTROPYSTRUCT) + 1024 -1;
	ppes = malloc (iBufferLen);

	while (!_kbhit ()) {
		Sleep (1000);
		ppes->ulOperation = kPGPUDOperation_QueryEntropy;
		ppes->ulBufferLength = sizeof(ULONG);
		if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_ENTROPY, 
			ppes, iBufferLen, ppes, iBufferLen, &dwReturned, NULL)) 
		{
			printf ("\n\nError: %i, Entropy: %li\n", 
					ppes->ulError, ppes->ulEntropyBits);
		}
		else {
			printf ("\nerr = %li", GetLastError ());
		}

		ppes->ulOperation = kPGPUDOperation_GetEntropy;
		ppes->ulBufferLength = 8;
		if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_ENTROPY, 
			ppes, iBufferLen, ppes, iBufferLen, &dwReturned, NULL)) 
		{
			printf ("\n\nError: %i\n", ppes->ulError);

			for (j=0; j<8; j++) {
				printf (" %02X", ppes->ucEntropyBuffer[j]);
			}
		}
		else 
		{
			printf ("\nerr = %li", GetLastError ());
		}
	}
#endif // ENTROPY_TEST

#if CACHE_TEST
	iBufferLen = sizeof(pcs);
	while (bLoop)
	{
		pcs.ucData[0] = '\0';

		printf ("\n\nEnter : 0 - to exit\n");
		printf (    "        1 - to set cache value\n");
		printf (    "        2 - to query cache value\n");
		printf (    "        3 - to purge cache\n : ");

		gets (sz);
		j = atoi(sz);

		switch (j) {
		case 0 :
			bLoop = FALSE;
			break;

		case 1 :
			pcs.ulOperation = kPGPUDOperation_SetCacheValue;

			printf ("\nEnter cache (0-sign, 1-decrypt) : ");
			gets (sz);
			pcs.ulCache = atoi(sz);

			printf ("\nEnter cache index : ");
			gets (sz);
			pcs.ulIndexLength = lstrlen (sz);
			strcpy (pcs.ucIndex, sz);

			printf ("\nEnter cache value : ");
			gets (sz);
			pcs.ulDataLength = lstrlen (sz);
			strcpy (pcs.ucData, sz);

			printf ("\nEnter cache time : ");
			gets (sz);
			pcs.ulSeconds = atoi (sz);

			break;

		case 2 :
			pcs.ulOperation = kPGPUDOperation_QueryCacheValue;
			memset (pcs.ucData, 0, kPGPUDMaxCacheDataLength);

			printf ("\nEnter cache (0-sign, 1-decrypt) : ");
			gets (sz);
			pcs.ulCache = atoi(sz);

			printf ("\nEnter cache index : ");
			gets (sz);
			pcs.ulIndexLength = lstrlen (sz);
			strcpy (pcs.ucIndex, sz);

			break;

		case 3 :
			pcs.ulOperation = kPGPUDOperation_PurgeCache;

			printf ("\nEnter cache (0-sign, 1-decrypt) : ");
			gets (sz);
			pcs.ulCache = atoi(sz);

			break;
		}

		if (bLoop)
		{
			if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_CACHE, 
				&pcs, iBufferLen, &pcs, iBufferLen, &dwReturned, NULL))
			{	
				printf ("\n\nError: %x, Value: %s\n", 
						pcs.ulError, pcs.ucData);
			}
			else 
			{
				printf ("\nerr = %li", GetLastError ());
			}
		}
	}
#endif // CACHE_TEST

#if INACTIVITY_TEST
	iBufferLen = sizeof(pis);
	while (bLoop)
	{
		pcs.ucData[0] = '\0';

		printf ("\n\nEnter : 0 - to exit\n");
		printf (    "        1 - to set inactivity timer\n");
		printf (    "        2 - to destroy inactivity timer\n");

		gets (sz);
		j = atoi(sz);

		switch (j) {
		case 0 :
			bLoop = FALSE;
			break;

		case 1 :
			pis.ulOperation = kPGPUDOperation_CreateInactivityTimer;

			printf ("\nEnter flag (0-single, 1-repeat) : ");
			gets (sz);
			pis.ulFlags = atoi(sz);

			printf ("\nEnter inactivity time : ");
			gets (sz);
			pis.ulSeconds = atoi (sz);

			pis.callback = NULL;
			pis.ulUserValue = 0x87654321;

			break;

		case 2 :
			pis.ulOperation = kPGPUDOperation_DestroyInactivityTimer;

			break;
		}

		if (bLoop)
		{
			if (DeviceIoControl (hPGPUtilDriver, IOCTL_PGPUTIL_INACTIVITY, 
				&pis, iBufferLen, &pis, iBufferLen, &dwReturned, NULL))
			{	
				printf ("\n\nError: %x, Handle: %x\n", 
						pis.ulError, pis.ulTimerHandle);
			}
			else 
			{
				printf ("\nerr = %li", GetLastError ());
			}
		}
	}
#endif // INACTIVITY_TEST


	if (!CloseHandle (hPGPUtilDriver)) {
		printf ("\nclose err = %li", GetLastError ());
	}
	else {
		printf ("\nclosed OK");
	}

	if (ppes)
		free (ppes);
	
	return 0;
}		
